/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class ButtonInput
extends AbstractInput {
    private Composite comp;
    protected Control clientControl;
    protected String value;
    protected boolean clientControlEnabled = true;
    protected boolean buttonEnabled = true;
    private Button button;
    private String buttonText;
    private Image buttonImage;
    private ArrayList<Listener> buttonListeners = new ArrayList();
    private boolean focus = false;
    private boolean inUpdate = false;

    public abstract Control getClientControl(Composite var1);

    @Override
    public final Control getControl() {
        if (this.comp != null && !this.comp.isDisposed()) {
            return this.comp;
        }
        this.comp = new Composite(this.getParent(), 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        this.comp.setLayout((Layout)layout);
        this.clientControl = this.getClientControl(this.comp);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.clientControl.setToolTipText(tooltip.toString());
        }
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        this.clientControl.setLayoutData((Object)gd);
        this.clientControl.setEnabled(this.clientControlEnabled);
        if (this.focus) {
            this.clientControl.setFocus();
        }
        this.button = GUI.getStyleFactory().createButton(this.comp);
        if (this.buttonImage == null && this.buttonText == null) {
            int os = Application.getPlatform().getOS();
            if (os == 2 || os == 5) {
                this.button.setText(" ...  ");
            } else {
                this.button.setText("...");
            }
        } else if (this.buttonImage != null) {
            this.button.setImage(this.buttonImage);
        } else if (this.buttonText != null) {
            this.button.setText(this.buttonText);
        }
        this.button.setLayoutData((Object)new GridData(128));
        this.button.setAlignment(131072);
        this.button.setEnabled(this.buttonEnabled);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Event event = new Event();
                event.data = e.data;
                event.detail = e.detail;
                event.display = e.display;
                event.doit = e.doit;
                event.item = e.item;
                event.width = e.width;
                event.height = e.height;
                event.x = e.x;
                event.y = e.y;
                for (int i = 0; i < ButtonInput.this.buttonListeners.size(); ++i) {
                    ButtonInput.this.buttonListeners.get(i).handleEvent(event);
                }
            }
        });
        return this.comp;
    }

    public final void setButtonText(String text) {
        this.buttonText = text;
        if (this.button != null && !this.button.isDisposed() && this.buttonImage == null) {
            this.button.setText(this.buttonText);
        }
    }

    public final void setButtonImage(Image image) {
        this.buttonImage = image;
        if (this.button != null && !this.button.isDisposed() && this.buttonText == null) {
            this.button.setImage(this.buttonImage);
        }
    }

    protected final void addButtonListener(Listener l) {
        if (l == null) {
            return;
        }
        this.buttonListeners.add(l);
    }

    @Override
    public final void focus() {
        this.focus = true;
        if (this.clientControl != null && !this.clientControl.isDisposed()) {
            this.clientControl.setFocus();
        }
    }

    @Override
    public final void disable() {
        this.setEnabled(false);
    }

    @Override
    public final void enable() {
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enableButton();
            this.enableClientControl();
        } else {
            this.disableButton();
            this.disableClientControl();
        }
        this.update();
    }

    public final void enableClientControl() {
        this.clientControlEnabled = true;
        if (this.clientControl != null && !this.clientControl.isDisposed()) {
            this.clientControl.setEnabled(true);
            this.update();
        }
    }

    public final void enableButton() {
        this.buttonEnabled = true;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(true);
            this.update();
        }
    }

    public final void disableClientControl() {
        this.clientControlEnabled = false;
        if (this.clientControl != null && !this.clientControl.isDisposed()) {
            this.clientControl.setEnabled(false);
            this.update();
        }
    }

    public final void disableButton() {
        this.buttonEnabled = false;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(false);
            this.update();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.buttonEnabled && this.clientControlEnabled;
    }

    @Override
    protected void update() throws OperationCanceledException {
        if (this.inUpdate) {
            throw new OperationCanceledException();
        }
        try {
            this.inUpdate = true;
            if (this.comp == null || this.comp.isDisposed()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            Object value = this.getValue();
            if (this.isMandatory() && (value == null || "".equals(value.toString()))) {
                this.clientControl.setBackground(Color.MANDATORY_BG.getSWTColor());
                return;
            }
            this.clientControl.setBackground(null);
        }
        finally {
            this.inUpdate = false;
        }
    }
}

